/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.network;

import dev.terminalmc.moremousetweaks.MoreMouseTweaks;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class InteractionManager {
    public static final Waiter TICK_WAITER = type -> type == TriggerType.TICK;
    private static final Queue<InteractionEvent> eventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    private static Waiter waiter;

    public static void pushClickEvent(int containerId, int slotId, int mouseButton, class_1713 clickType) {
        InteractionManager.push(new ClickEvent(containerId, slotId, mouseButton, clickType, TICK_WAITER));
    }

    public static void pushCallbackEvent(Supplier<Waiter> callback) {
        InteractionManager.push(new CallbackEvent(callback));
    }

    public static void pushPacketEvent(class_2596<?> packet, Waiter waiter) {
        InteractionManager.push(new PacketEvent(packet, waiter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(InteractionEvent event) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            eventQueue.add(event);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            eventQueue.clear();
            waiter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerSend(TriggerType type) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            if (waiter == null || waiter.trigger(type)) {
                do {
                    InteractionEvent event;
                    if ((event = eventQueue.poll()) == null) {
                        waiter = null;
                        break;
                    }
                    InteractionManager.doSendEvent(event);
                } while (waiter.trigger(TriggerType.INITIAL));
            }
        }
    }

    private static void doSendEvent(InteractionEvent event) {
        Waiter blockingWaiter;
        waiter = blockingWaiter = triggerType -> false;
        class_310.method_1551().execute(() -> {
            Queue<InteractionEvent> queue = eventQueue;
            synchronized (queue) {
                if (waiter == blockingWaiter) {
                    waiter = event.send();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWaiter(Waiter waiter) {
        Queue<InteractionEvent> queue = eventQueue;
        synchronized (queue) {
            InteractionManager.waiter = waiter;
        }
    }

    public static void setTickRate(long intervalMs) {
        if (tickFuture != null) {
            tickFuture.cancel(false);
        }
        tickFuture = executor.scheduleAtFixedRate(InteractionManager::tick, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
    }

    public static void tick() {
        try {
            InteractionManager.triggerSend(TriggerType.TICK);
        }
        catch (Exception e) {
            MoreMouseTweaks.LOG.error("Error while ticking InteractionManager", e);
        }
    }

    static {
        waiter = null;
    }

    public static class ClickEvent
    implements InteractionEvent {
        private final Waiter waiter;
        private final int containerId;
        private final int slotId;
        private final int mouseButton;
        private final class_1713 clickType;

        public ClickEvent(int containerId, int slotId, int mouseButton, class_1713 clickType, Waiter waiter) {
            this.containerId = containerId;
            this.slotId = slotId;
            this.mouseButton = mouseButton;
            this.clickType = clickType;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_310 mc = class_310.method_1551();
            if (mc.field_1761 == null) {
                MoreMouseTweaks.LOG.error("Unable to send click event: gameMode is null", new Object[0]);
            } else if (mc.field_1724 == null) {
                MoreMouseTweaks.LOG.error("Unable to send click event: player is null", new Object[0]);
            } else {
                mc.field_1761.method_2906(this.containerId, this.slotId, this.mouseButton, this.clickType, (class_1657)mc.field_1724);
            }
            return this.waiter;
        }
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);

        public static Waiter equal(TriggerType type) {
            return type::equals;
        }
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;

        public CallbackEvent(Supplier<Waiter> callback) {
            this.callback = callback;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }
    }

    public static class PacketEvent
    implements InteractionEvent {
        private final class_2596<?> packet;
        private final Waiter waiter;

        public PacketEvent(class_2596<?> packet, Waiter waiter) {
            this.packet = packet;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_634 connection = class_310.method_1551().method_1562();
            if (connection == null) {
                MoreMouseTweaks.LOG.error("Unable to send packet event: connection is null", new Object[0]);
            } else {
                connection.method_52787(this.packet);
            }
            return this.waiter;
        }
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        HELD_ITEM_CHANGE,
        TICK;

    }
}

